const Router = require("express").Router();
const { DB } = require("../../db");
const { verifySession } = require("../../middleware/verifySession");
const { VIEW_NOTIFICATION } = require("../../validators/account");

// view and read all nots
Router.post("/read/notifications", verifySession, async (req, res) => {
  try {
    let { error, value } = VIEW_NOTIFICATION.validate(req.body);
    if (error) throw new Error(error.details[0].message);

    const { ids } = value;

    // view and read all nots
    await DB.NOTIFICATION.updateMany(
      { _id: { $in: ids } }, // Filter criteria
      { $set: { read: true } } // Update object
    );

    res.status(201).json({
      data: "Successful",
    });
  } catch (error) {
    res.status(500).json({
      msg: error.message || "unable to complete request",
    });
    console.log(error);
  }
});

// delete nots
Router.delete("/delete/notifications", verifySession, async (req, res) => {
  try {
    let { error, value } = VIEW_NOTIFICATION.validate(req.body);
    if (error) throw new Error(error.details[0].message);

    const { ids } = value;

    // delete all nots
    await DB.NOTIFICATION.deleteMany({
      _id: { $in: ids },
    });

    res.status(201).json({
      data: "Successful",
    });
  } catch (error) {
    res.status(500).json({
      msg: error.message || "unable to complete request",
    });
    console.log(error);
  }
});

module.exports = Router;
