const { Schema, model } = require("mongoose");

const userModel = new Schema(
  {
    transaction_status: { type: String, default: "successful", enum: ["successful", "pending", "fail"] },
    failed_transaction_msg: String,
    vat: {
      type: Object,
      default: {
        status: 'paid', // 'not-paid
        code: '12345'
      }
    },
    image: String,
    img: Object,
    email: {
      type: String,
      required: [true, "Email address is required"],
    },
    alert: { 
      type: Object,
      direction: {
        type: String,
        enum: ["email", "phone"],
        default: "email",
      },
    },
    otp: {
      type: Object,
      code: {
        type: String,
      },
      direction: {
        type: String,
        enum: ["email", "phone", "authenticator"],
        default: "authenticator",
      },
    },
    name: {
      first: String,
      last: String,
    },
    tfa: {
      type: Object,
      required: [true, "2FA sector error"], // Ensure tfa object is provided
      token: {
        type: String,
        default: "", // Default value for token if not provided
      },
      status: {
        type: String,
        enum: ["active", "inactive"],
        default: "inactive", // Default status is 'inactive' if not provided
      },
    },
    phone: {
      type: String,
      required: [true, "phone is required"],
    },
    password: {
      type: String,
      required: [true, "Password is required"],
    },
    suspended: {
      type: Array,
      default: [], //an array of suspended functions for the user
    },
    type: {
      type: String,
      enum: ["user", "admin"],
      default: "user",
    },
    account: {
      required: [true, "user account set failed"],
      type: Object,
      number: Number,
      balance: {
        type: Object,
        default: {
          usd: 0,
          gbp: 0,
          euro: 0,
        },
      },
    },
  },
  {
    timestamps: true,
  }
);

module.exports = model("users", userModel);
