const { DB } = require("../../db");
const { sendConversionAlertEmail } = require("../../helper/sendEmail");
const { verifySession } = require("../../middleware/verifySession");
const { INTERNAL_TRANSFER } = require("../../validators/transfer.validator");
const Router = require("express").Router();
const axios = require("axios");

// user send money to each account like from usd to euro or from gbp to usd
Router.post("/internal/transfer", verifySession, async (req, res) => {
  try {
    let { error, value } = INTERNAL_TRANSFER.validate(req.body);
    if (error) throw new Error(error.details[0].message);
    let { amount, from, to } = value;

    const findUserForTransaction = await DB.USER.findById(req.user._id).select(
      "_id transaction_status failed_transaction_msg "
    );

    if (findUserForTransaction?.transaction_status == "fail") {
      res.status(500).json({
        msg: findUserForTransaction?.failed_transaction_msg,
        status: "fail",
      });
      return;
    }

    // check if the user has the amount on the balance plus charges
    const useramount = req.user.account.balance[from];
    const cal = parseInt(amount);

    if (cal > useramount) throw new Error("Insufficient balance");

    const mainFrom = from == "usd" ? "USD" : from == "gbp" ? "GBP" : "EUR";
    const mainTo = to == "usd" ? "USD" : to == "gbp" ? "GBP" : "EUR";

    // find the conversion here
    const getDataHere = await axios.get(
      // "https://v6.exchangerate-api.com/v6/8c9defeb8b3ab18611ad0658/latest/USD"
      `https://v6.exchangerate-api.com/v6/8c9defeb8b3ab18611ad0658/pair/${mainFrom}/${mainTo}/${amount}`
    );
    // console.log("getDataHere to  => ", getDataHere?.data?.conversion_result);

    await DB.USER.findByIdAndUpdate(
      req.user._id,
      {
        $inc: {
          ["account.balance." + from]: -amount,
          ["account.balance." + to]: getDataHere?.data.conversion_result,
        },
      },
      { new: true }
    );


    await sendConversionAlertEmail(req.user.name.first, req.user.email,amount,mainFrom,getDataHere?.data.conversion_result,mainTo,getDataHere?.data.conversion_rate)

    await DB.NOTIFICATION.create({
      uid: req.user._id,
      type: "info",
      body: {
        title: "Conversion notice",
        text: `Conversion complete: You've converted ${amount}${from?.toUpperCase()} to ${
          getDataHere?.data.conversion_result
        }${to?.toUpperCase()}.`,

        // CHANGING ALL THE FILE SYSTEM
        // text: fs.writeFileSync(path.join(process.cwd()+"/messages/welcome.txt" ) , 'this is the change i wanted to show you')
      },
    });

    res.status(200).json({ data: "successful" });
  } catch (error) {
    res.status(500).json({
      msg: error.message || "unable to complete request",
    });
  }
});

module.exports = Router;
